\name{print.sienaBayesFit}
\alias{print.sienaBayesFit}
\alias{summary.sienaBayesFit}
\alias{print.summary.sienaBayesFit}
\alias{sienaBayes.table}
\alias{shortBayesResults}
\alias{plotPostMeansMDS}
\title{Methods and functions for processing sienaBayes objects}
\usage{
\method{print}{sienaBayesFit}(x, nfirst=NULL, ...)

\method{summary}{sienaBayesFit}(object, nfirst=NULL, allGroups=FALSE, ...)

\method{print}{summary.sienaBayesFit}(x, nfirst=NULL, allGroups=FALSE, ...)

sienaBayes.table(x, nfirst=NULL, d=3,
    filename=paste(deparse(substitute(x)),'.tex',sep=""), align=TRUE)

shortBayesResults(x, nfirst=NULL)

plotPostMeansMDS(x=NULL, pm=NULL, pmonly=1, dim=2,  method=1, excludeRates=TRUE,
   nfirst=NULL, main=NULL, ...)
}
\description{
  \code{print} and \code{summary} methods for \code{\link{sienaBayesFit}} objects,
  and further functions for interpretation of results.
}
\arguments{
  \item{object}{An object of class \code{\link{sienaBayesFit}}.}
  \item{x}{An object of class  \code{\link{sienaBayesFit}} or
    \code{summary.sienaBayesFit} as appropriate.}
  \item{nfirst}{The first element of the MCMC chain used for calculating
      properties of the chain; i.e., the first element for which
      it is assumed that convergence has occurred. If \code{NULL},
      the value \code{x$nwarm+1} will be used.}
  \item{allGroups}{Logical: whether to print results for each group.}
  \item{pm}{In \code{plotPostMeansMDS}, at least one of \code{x} or \code{pm}
      should be given.\cr
      If \code{pm} is not \code{NULL}, it should be an earlier obtained result of
      \code{\link{extract.posteriorMeans}}. If this is given, it overrides
      the values of \code{pmonly} and \code{excludeRates}.}
  \item{pmonly}{if \code{pmonly=0} a plot is made for posterior means and standard
      deviations:
      if \code{pmonly=1} only for the posterior means,
      if \code{pmonly=2} only for the posterior standard deviations.}
  \item{dim}{Dimension of the MDS representation.
      For \code{dim=1} the single dimension is plotted vertically, and the horizontal
      dimension is the sequence number of the group.
      For \code{dim >= 3} only the first two dimensions are plotted. }
  \item{method}{Method for determining the similarities between the
     vectors of posterior means. See "Details".}
  \item{excludeRates}{Logical: whether to exclude the rate parameters
      for determining the coordinates.}
  \item{\dots}{For extra arguments. At present used only for
     further specification of the plot made by \code{plotPostMeansMDS},
    allowing further arguments for \code{\link{plot}} and \code{\link{text}}.}
  \item{main}{Parameter \code{main} in \code{\link{plot}}; if \code{NULL},
    "MDS" with name of \code{x}.}
  \item{filename}{filename for output; if "", printed to the console.}
  \item{d}{Number of decimals to be used in table.}
  \item{align}{Whether to align numbers at the decimal point.}
}
\details{
  The function \code{print.sienaBayesFit} prints results (estimated posterior means,
  posterior standard deviations, and percentiles) of a Bayesian analysis, as resulting
  from function \code{\link{sienaBayes}}.\cr
  The function \code{summary.sienaBayesFit} prints more extensive results,
  including groupwise results.\cr
  The columns "cred. from" and "cred. to" give the left and right end points
  of the estimated 95 percent credibility interval for the parameters, and the
  column "p" gives the estimated posterior probability that the parameter is
  greater than 0.\cr

  The function \code{plotPostMeansMDS} uses an MDS plot of the posterior means;
  if \code{pm} is not \code{NULL}, function \code{\link{extract.posteriorMeans}}
  will be used to compute it.\cr
  For \code{method=1} the dissimilarities are the sum of squared differences
  of distances between the posterior means normalized and orthogonalized
  with respect to a robustly estimated covariance matrix;\cr
  for \code{method=2} the dissimilarities are the sum of squared differences
  of distances between the posterior means divided by their standard deviations;\cr
  for \code{method=3} the dissimilarities are the sum of squared differences
  of distances between the posterior means.

  Function \code{plotPostMeansMDS} uses random starting points, and running it
  will give a different result each time it is done. On convergence, it reports
  the minimized stress function. Since this usually will be a local minimum only,
  it is advisable to do it repeatedly and then interpret the plot
  with the lowest stress value.

  Function \code{plotPostMeansMDS} can be useful for detection of outliers,
  or can signal that too many randomly varying effects
  are included in the model.

  It is advisable to employ the \code{first} parameter; looking at trace plots
  will be helpful to estimate the number of runs from which convergence
  has occurred; this may well be different from the default value \code{x$nwarm+1}.

  Function \code{\link{siena.table}} can also be used to make html or LaTeX
  tables of posterior means and standard deviations of a
  \code{\link{sienaBayesFit}} object.
}
\value{
  The function \code{shortBayesResults} produces a data frame containing
  posterior means and between-group standard deviations, and
  95 percent crdibility intervals.
  This is meant to be a component for use in other functions.\cr
  Of this data frame, variables "name" to "effectName" are as in a
  \code{\link{sienaEffects}} object;
  variables "postMeanGlobal", "postSdGlobal", "cFrom", "cTo" are the posterior
  mean, posterior standard deviation, and lower and upper boundaries of the
  95 percent posterior interval for the global parameters (\code{mu} and
  \code{eta});
  variables  "postSdBetween", "cSdFrom", "cSdTo" are the posterior mean,
  and similar percentiles, for the global between-group standard deviations
  (\code{sigma}) of the parameters that are randomly varying between groups.

  Function \code{sienaBayes.table} is based on \code{shortBayesResults} and
  constructs a LaTeX tables of posterior means and
  posterior between-groups standard deviations.

  The return value of  \code{plotPostMeansMDS} is a list with three components:\cr
  \code{pm}, the matrix of posterior means;\cr
  \code{dist}, the dissimilarities between the groups, used for the MDS;\cr
  \code{points}, the matrix of \code{dim}-dimensional MDS coordinates.

}
\seealso{\code{\link{siena.table}}, \code{\link{sienaBayes}},
    \code{\link{extract.sienaBayes}}, \code{\link{extract.posteriorMeans}}.}
\references{
  See also \url{http://www.stats.ox.ac.uk/~snijders/siena/}
  \cr
  For \code{plotPostMeansMDS}: for the MDS method see p. 308
  and for the robust covariance matrix see p. 336 of\cr
  W.N. Venables and B.D. Ripley (2002),
  \emph{Modern Applied Statistics with S.} Fourth edition. Springer.
}
\author{Tom Snijders}
\keyword{print}
\examples{
# Construct a list of Siena data sets of smallNetworks
# together with group-level variable "num", the rank number in 1:50
mData <- list()
for (i in 1:20){
    net <- sienaDependent(array(c(smallNetworks[[1]],smallNetworks[[i+1]]),
                            dim=c(5,5,2)), allowOnly=FALSE)
    num <- coCovar(rep(i,5), warn=FALSE)
    mData[[i]] <- sienaDataCreate(net,num)
}
# Construct the multigroup dataset:
(multiData <- sienaGroupCreate(mData))
# specify model
eff.p <- getEffects(multiData)
eff.p <- setEffect(eff.p, density, random=TRUE)
eff.p <- setEffect(eff.p, recip, random=TRUE)
eff.p <- setEffect(eff.p, transTrip, random=TRUE)
eff.p <- setEffect(eff.p, egoX, interaction1='num')
eff.p <- includeInteraction(eff.p, egoX, recip, interaction1=c('num',''))
eff.p <- includeInteraction(eff.p, egoX, transTrip, interaction1=c('num',''))
print(eff.p, includeRandoms=TRUE, dropRates=TRUE)
alg.ml <- sienaAlgorithmCreate(projname=NULL, seed=1234)
# Prior distribution; for rho it does not matter
# (because priorRatesFromData=2)
Mu <- c(1,-1,0.5,0.2)
Sig <- matrix(0,4,4)
diag(Sig) <- 0.09
# Estimate (the numbers of runs indicated are way too low):
bayes.model <- sienaBayes(alg.ml, data=multiData,
       effects=eff.p, nprewarm=10, nwarm=25, nmain=50, nrunMHBatches=2,
       initgainGroupwise=0, reductionFactor=0.1,
       priorMu=Mu, priorSigma=Sig, priorKappa=0.09,
       silentstart=TRUE, saveFreq=0)
# If one would assume that convergence was reached by iteration 30 out of 75:
print(bayes.model, nfirst=30)
summary(bayes.model)
siena.table(bayes.model, type="html", d=3)
shortBayesResults(bayes.model)
pm <- extract.posteriorMeans(bayes.model)
ppm <- plotPostMeansMDS(bayes.model, pm=pm)
}
\keyword{print}
